package com.agilex.healthcare.veteranappointment.domain;

import agilex.commons.dateutils.Dateable;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointmentRequestMessage", namespace = Namespace.VeteranAppointmentRequest)
public class VARAppointmentRequestMessage extends PatientData implements Dateable {

	private static final long serialVersionUID = -1232048559610824267L;;

    @XmlElement
    private String messageText;

    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date messageDateTime;

    @XmlElement
    private String AppointmentRequestId;

    @XmlElement
    private String senderId;  //patient or staff id

    public String getMessageText() {
        return messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public Date getMessageDateTime() {
        return messageDateTime;
    }

    public void setMessageDateTime(Date messageDateTime) {
        this.messageDateTime = messageDateTime;
    }

    public String getAppointmentRequestId() {
        return AppointmentRequestId;
    }

    public void setAppointmentRequestId(String appointmentRequestId) {
        AppointmentRequestId = appointmentRequestId;
    }

    public String getSenderId() {
        return senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

	@Override
	public Date getDate() {
        return this.messageDateTime;
	}
}
